/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field303;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT032
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT032.class.getName());
    public static final String NAME = "032";

    public MT032(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT032(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT032 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT032(m);
    }

    public MT032() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT032(String sender, String receiver) {
        super(32, sender, receiver);
    }

    public MT032(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT032.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT032 object from FIN content with a Service Message. Check if the MT032 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT032 object from FIN content with message type " + param.getType());
        }
    }

    public static MT032 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT032(fin);
    }

    public MT032(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT032 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT032(stream);
    }

    public MT032(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT032 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT032(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT032 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT032 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT032 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT032 fromJson(String json) {
        return (MT032)AbstractMT.fromJson(json);
    }

    public Field303 getField303() {
        Tag t = this.tag("303");
        if (t != null) {
            return new Field303(t.getValue());
        }
        return null;
    }
}

