/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23R;
import com.prowidesoftware.swift.model.field.Field23X;
import com.prowidesoftware.swift.model.field.Field26E;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field72Z;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT787
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT787.class.getName());
    public static final String NAME = "787";

    public MT787(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT787(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT787 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT787(m);
    }

    public MT787() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT787(String sender, String receiver) {
        super(787, sender, receiver);
    }

    public MT787(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT787.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT787 object from FIN content with a Service Message. Check if the MT787 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT787 object from FIN content with message type " + param.getType());
        }
    }

    public static MT787 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT787(fin);
    }

    public MT787(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT787 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT787(stream);
    }

    public MT787(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT787 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT787(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT787 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT787 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT787 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT787 fromJson(String json) {
        return (MT787)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field26E getField26E() {
        Tag t = this.tag("26E");
        if (t != null) {
            return new Field26E(t.getValue());
        }
        return null;
    }

    public Field23R getField23R() {
        Tag t = this.tag("23R");
        if (t != null) {
            return new Field23R(t.getValue());
        }
        return null;
    }

    public Field72Z getField72Z() {
        Tag t = this.tag("72Z");
        if (t != null) {
            return new Field72Z(t.getValue());
        }
        return null;
    }

    public Field23X getField23X() {
        Tag t = this.tag("23X");
        if (t != null) {
            return new Field23X(t.getValue());
        }
        return null;
    }
}

