/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.ResolverUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AmountResolver {
    private static final Logger log = Logger.getLogger(AmountResolver.class.getName());

    public static List<BigDecimal> amounts(Field f) {
        Objects.requireNonNull(f);
        List<String> values = ResolverUtils.findNonNullWantedType(f.typesPattern(), 'I', f.getComponents());
        return values.stream().map(SwiftFormatUtils::getBigDecimal).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static BigDecimal amount(Field f) {
        Objects.requireNonNull(f);
        String value = ResolverUtils.findFirstWantedType(f.typesPattern(), 'I', f.getComponents());
        if (value != null) {
            return SwiftFormatUtils.getBigDecimal(value);
        }
        return null;
    }
}

