/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionKPartyField
extends Field {
    public static final String PARSER_PATTERN = "[/S$]S[$S]0-3";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSSS";
    public static final String TYPES_PATTERN = "SSSSS";
    public static final Integer ACCOUNT = 1;
    public static final Integer NAME_AND_ADDRESS = 2;

    public OptionKPartyField() {
        super(5);
    }

    public OptionKPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(5);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            if (lines.get(0).startsWith("/")) {
                this.setComponent(1, StringUtils.substring((String)lines.get(0), (int)1));
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 1, lines);
            } else {
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 0, lines);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        this.appendInLines(result, 2, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "SSSSS";
    }

    @Override
    public final String typesPattern() {
        return "SSSSS";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "account");
        result.put(2, "nameAndAddress");
        result.put(3, "nameAndAddress2");
        result.put(4, "nameAndAddress3");
        result.put(5, "nameAndAddress4");
        return result;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String c = this.getComponent(1);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent(5);
    }

    public String getNameAndAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 6; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }
}

