/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field17B;
import com.prowidesoftware.swift.model.field.Field19B;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field22H;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field36B;
import com.prowidesoftware.swift.model.field.Field70C;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98B;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.field.Field98E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT503
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT503.class.getName());
    public static final String NAME = "503";

    public MT503(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT503(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT503 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT503(m);
    }

    public MT503() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT503(String sender, String receiver) {
        super(503, sender, receiver);
    }

    public MT503(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT503.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT503 object from FIN content with a Service Message. Check if the MT503 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT503 object from FIN content with message type " + param.getType());
        }
    }

    public static MT503 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT503(fin);
    }

    public MT503(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT503 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT503(stream);
    }

    public MT503(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT503 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT503(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT503 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT503 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT503 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT503 fromJson(String json) {
        return (MT503)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98E getField98E() {
        Tag t = this.tag("98E");
        if (t != null) {
            return new Field98E(t.getValue());
        }
        return null;
    }

    public Field35B getField35B() {
        Tag t = this.tag("35B");
        if (t != null) {
            return new Field35B(t.getValue());
        }
        return null;
    }

    public Field36B getField36B() {
        Tag t = this.tag("36B");
        if (t != null) {
            return new Field36B(t.getValue());
        }
        return null;
    }

    public Field17B getField17B() {
        Tag t = this.tag("17B");
        if (t != null) {
            return new Field17B(t.getValue());
        }
        return null;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70C> getField70C() {
        ArrayList<Field70C> result = new ArrayList<Field70C>();
        Tag[] tags = this.tags("70C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22H> getField22H() {
        ArrayList<Field22H> result = new ArrayList<Field22H>();
        Tag[] tags = this.tags("22H");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22H(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field19B> getField19B() {
        ArrayList<Field19B> result = new ArrayList<Field19B>();
        Tag[] tags = this.tags("19B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field19B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98C> getField98C() {
        ArrayList<Field98C> result = new ArrayList<Field98C>();
        Tag[] tags = this.tags("98C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98B> getField98B() {
        ArrayList<Field98B> result = new ArrayList<Field98B>();
        Tag[] tags = this.tags("98B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98B(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT503.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("AGRE")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock("AGRE").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceA2> getSequenceA2List() {
        return MT503.getSequenceA2List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA2> getSequenceA2List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA2> result = new ArrayList<SequenceA2>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA2 s = new SequenceA2();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceB getSequenceB() {
        return new SequenceB(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        SequenceB s = new SequenceB();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("SUMM").getTags());
        }
        return s;
    }

    public SequenceB1 getSequenceB1() {
        return new SequenceB1(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB1 getSequenceB1(SwiftTagListBlock parentSequence) {
        SequenceB1 s = new SequenceB1();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("SUMD").getTags());
        }
        return s;
    }

    public List<SequenceC> getSequenceCList() {
        return MT503.getSequenceCList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC> getSequenceCList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("COLD")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC> result = new ArrayList<SequenceC>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC s = new SequenceC();
                s.setTags(b.getSubBlock("COLD").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceC1> getSequenceC1List() {
        return MT503.getSequenceC1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC1> getSequenceC1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SCOL")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC1> result = new ArrayList<SequenceC1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC1 s = new SequenceC1();
                s.setTags(b.getSubBlock("SCOL").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceC2> getSequenceC2List() {
        return MT503.getSequenceC2List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC2> getSequenceC2List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CCOL")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC2> result = new ArrayList<SequenceC2>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC2 s = new SequenceC2();
                s.setTags(b.getSubBlock("CCOL").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceC3> getSequenceC3List() {
        return MT503.getSequenceC3List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC3> getSequenceC3List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("BCOL")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC3> result = new ArrayList<SequenceC3>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC3 s = new SequenceC3();
                s.setTags(b.getSubBlock("BCOL").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceD getSequenceD() {
        return new SequenceD(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceD getSequenceD(SwiftTagListBlock parentSequence) {
        SequenceD s = new SequenceD();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("ADDINFO").getTags());
        }
        return s;
    }

    public static class SequenceD
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "ADDINFO";
        public static final Tag START_TAG = new Tag("16R", "ADDINFO");
        public static final Tag END_TAG = new Tag("16S", "ADDINFO");

        private SequenceD() {
            super(new ArrayList<Tag>());
        }

        private SequenceD(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceD newInstance(Tag ... tags) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceD newInstance() {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceD newInstance(SwiftTagListBlock ... sequences) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceD(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC3
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "BCOL";
        public static final Tag START_TAG = new Tag("16R", "BCOL");
        public static final Tag END_TAG = new Tag("16S", "BCOL");

        private SequenceC3() {
            super(new ArrayList<Tag>());
        }

        private SequenceC3(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC3 newInstance(Tag ... tags) {
            SequenceC3 result = new SequenceC3();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC3 newInstance() {
            SequenceC3 result = new SequenceC3();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC3 newInstance(SwiftTagListBlock ... sequences) {
            SequenceC3 result = new SequenceC3();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC3(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CCOL";
        public static final Tag START_TAG = new Tag("16R", "CCOL");
        public static final Tag END_TAG = new Tag("16S", "CCOL");

        private SequenceC2() {
            super(new ArrayList<Tag>());
        }

        private SequenceC2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC2 newInstance(Tag ... tags) {
            SequenceC2 result = new SequenceC2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC2 newInstance() {
            SequenceC2 result = new SequenceC2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceC2 result = new SequenceC2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SCOL";
        public static final Tag START_TAG = new Tag("16R", "SCOL");
        public static final Tag END_TAG = new Tag("16S", "SCOL");

        private SequenceC1() {
            super(new ArrayList<Tag>());
        }

        private SequenceC1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC1 newInstance(Tag ... tags) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance() {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "COLD";
        public static final Tag START_TAG = new Tag("16R", "COLD");
        public static final Tag END_TAG = new Tag("16S", "COLD");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SUMD";
        public static final Tag START_TAG = new Tag("16R", "SUMD");
        public static final Tag END_TAG = new Tag("16S", "SUMD");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SUMM";
        public static final Tag START_TAG = new Tag("16R", "SUMM");
        public static final Tag END_TAG = new Tag("16S", "SUMM");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA2() {
            super(new ArrayList<Tag>());
        }

        private SequenceA2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA2 newInstance(Tag ... tags) {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA2 newInstance() {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA2 result = new SequenceA2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "AGRE";
        public static final Tag START_TAG = new Tag("16R", "AGRE");
        public static final Tag END_TAG = new Tag("16S", "AGRE");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

