/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field19;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field53D;
import com.prowidesoftware.swift.model.field.Field54A;
import com.prowidesoftware.swift.model.field.Field54B;
import com.prowidesoftware.swift.model.field.Field54D;
import com.prowidesoftware.swift.model.field.Field56A;
import com.prowidesoftware.swift.model.field.Field56D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field58A;
import com.prowidesoftware.swift.model.field.Field58D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT203
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT203.class.getName());
    public static final String NAME = "203";

    public MT203(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT203(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT203 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT203(m);
    }

    public MT203() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT203(String sender, String receiver) {
        super(203, sender, receiver);
    }

    public MT203(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT203.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT203 object from FIN content with a Service Message. Check if the MT203 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT203 object from FIN content with message type " + param.getType());
        }
    }

    public static MT203 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT203(fin);
    }

    public MT203(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT203 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT203(stream);
    }

    public MT203(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT203 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT203(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT203 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT203 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT203 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT203 fromJson(String json) {
        return (MT203)AbstractMT.fromJson(json);
    }

    public Field19 getField19() {
        Tag t = this.tag("19");
        if (t != null) {
            return new Field19(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public Field53D getField53D() {
        Tag t = this.tag("53D");
        if (t != null) {
            return new Field53D(t.getValue());
        }
        return null;
    }

    public Field54A getField54A() {
        Tag t = this.tag("54A");
        if (t != null) {
            return new Field54A(t.getValue());
        }
        return null;
    }

    public Field54B getField54B() {
        Tag t = this.tag("54B");
        if (t != null) {
            return new Field54B(t.getValue());
        }
        return null;
    }

    public Field54D getField54D() {
        Tag t = this.tag("54D");
        if (t != null) {
            return new Field54D(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56A> getField56A() {
        ArrayList<Field56A> result = new ArrayList<Field56A>();
        Tag[] tags = this.tags("56A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field56D> getField56D() {
        ArrayList<Field56D> result = new ArrayList<Field56D>();
        Tag[] tags = this.tags("56D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field56D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57B> getField57B() {
        ArrayList<Field57B> result = new ArrayList<Field57B>();
        Tag[] tags = this.tags("57B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field58A> getField58A() {
        ArrayList<Field58A> result = new ArrayList<Field58A>();
        Tag[] tags = this.tags("58A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field58A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field58D> getField58D() {
        ArrayList<Field58D> result = new ArrayList<Field58D>();
        Tag[] tags = this.tags("58D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field58D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field72(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT203.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new SequenceB(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"58A", "58D"};
        protected static final String[] TAIL = new String[]{"72"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"19"};
        protected static final String[] END = new String[]{"30"};
        protected static final String[] TAIL = new String[]{"52A", "52D", "53A", "53B", "53D", "54A", "54B", "54D", "72"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

