/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TestUtils {
    private TestUtils() {
        throw new AssertionError();
    }

    public static SwiftMessage createMT(int type) {
        SwiftMessage result = new SwiftMessage(true);
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        b2.setMessageType(Integer.toString(type));
        b2.setInput(true);
        b2.setMessagePriority("N");
        b2.setDeliveryMonitoring("2");
        b2.setObsolescencePeriod("020");
        b2.setReceiverAddress("12345612XXXX");
        result.setBlock2(b2);
        return result;
    }

    public static SwiftMessage addSeq(SwiftMessage msg, String sequenceIdentifier, Tag ... tags) {
        msg.getBlock4().append(new Tag("16R", sequenceIdentifier));
        if (tags != null && tags.length > 0) {
            for (Tag t : tags) {
                msg.getBlock4().append(t);
            }
        }
        msg.getBlock4().append(new Tag("16S", sequenceIdentifier));
        return msg;
    }

    public static SwiftMessage enclose(SwiftMessage msg, String sequenceIdentifier, Tag ... tags) {
        List<Tag> block4 = msg.getBlock4().getTags();
        block4.add(0, new Tag("16R", sequenceIdentifier));
        if (tags != null && tags.length > 0) {
            for (int i = tags.length - 1; i >= 0; --i) {
                block4.add(1, tags[i]);
            }
        }
        block4.add(new Tag("16S", sequenceIdentifier));
        return msg;
    }

    public static void append(SwiftMessage m, SwiftTagListBlock block) {
        Objects.requireNonNull(m, "message must not be null");
        Objects.requireNonNull(block, "block must not be null");
        m.getBlock4().append(block);
    }

    public static String patch(String xpath) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = StringUtils.split((String)xpath, (String)"/");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s;
            String localName = s = stringArray[i];
            String predicate = null;
            if (s.indexOf(91) >= 0 && s.indexOf(93) >= 0) {
                predicate = StringUtils.substringBetween((String)s, (String)"[", (String)"]");
                localName = s.substring(0, s.indexOf(91));
            }
            result.append("/*[local-name()='").append(localName).append("']");
            if (predicate == null) continue;
            result.append('[').append(predicate).append(']');
        }
        return result.toString();
    }
}

